/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.codova.config.templates.AttributeSource;
import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.CheckTable;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.UnmodifiableIterator;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Count;
import com.floragunn.searchsupport.cstate.metrics.CountAggregation;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.floragunn.searchsupport.queries.DateMathExpressionResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoleBasedActionAuthorization
implements ActionAuthorization,
ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(RoleBasedActionAuthorization.class);
    private static final String USER_TENANT = "__user__";
    private final SgDynamicConfiguration<Role> roles;
    private final ActionGroup.FlattenedIndex actionGroups;
    private final Actions actions;
    private final ImmutableSet<String> tenants;
    private final ClusterPermissions cluster;
    private final ClusterPermissionExclusions clusterExclusions;
    private final IndexPermissions index;
    private final IndexPermissionExclusions indexExclusions;
    private final TenantPermissions tenant;
    private final ComponentState componentState;
    private final Pattern universallyDeniedIndices;
    private final MetricsLevel metricsLevel;
    private final Measurement<?> indexActionChecks;
    private final CountAggregation indexActionCheckResults;
    private final CountAggregation indexActionCheckResults_ok;
    private final CountAggregation indexActionCheckResults_insufficient;
    private final CountAggregation indexActionCheckResults_partially;
    private final CountAggregation indexActionTypes;
    private final CountAggregation indexActionTypes_wellKnown;
    private final CountAggregation indexActionTypes_nonWellKnown;
    private final Measurement<?> tenantActionChecks;
    private final CountAggregation tenantActionCheckResults;
    private final CountAggregation tenantActionCheckResults_ok;
    private final CountAggregation tenantActionCheckResults_insufficient;
    private final TimeAggregation statefulIndexRebuild = new TimeAggregation.Milliseconds();
    private volatile StatefulIndexPermssions statefulIndex;
    private final ComponentState statefulIndexState = new ComponentState("index_permissions_stateful");

    public RoleBasedActionAuthorization(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, Set<String> indices, Set<String> tenants) {
        this(roles, actionGroups, actions, indices, tenants, Pattern.blank(), MetricsLevel.NONE);
    }

    public RoleBasedActionAuthorization(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, Set<String> indices, Set<String> tenants, Pattern universallyDeniedIndices, MetricsLevel metricsLevel) {
        this.roles = roles;
        this.actionGroups = actionGroups;
        this.actions = actions;
        this.metricsLevel = metricsLevel;
        this.tenants = ImmutableSet.of(tenants);
        this.cluster = new ClusterPermissions(roles, actionGroups, actions, metricsLevel);
        this.clusterExclusions = new ClusterPermissionExclusions(roles, actionGroups, actions);
        this.index = new IndexPermissions(roles, actionGroups, actions);
        this.indexExclusions = new IndexPermissionExclusions(roles, actionGroups, actions);
        this.tenant = new TenantPermissions(roles, actionGroups, actions, this.tenants);
        this.universallyDeniedIndices = universallyDeniedIndices;
        this.componentState = new ComponentState("role_based_action_authorization");
        this.componentState.addParts(new ComponentState[]{this.cluster.getComponentState(), this.clusterExclusions.getComponentState(), this.index.getComponentState(), this.indexExclusions.getComponentState(), this.tenant.getComponentState(), this.statefulIndexState});
        if (indices != null) {
            try (Meter meter = Meter.basic((MetricsLevel)metricsLevel, (TimeAggregation)this.statefulIndexRebuild);){
                this.statefulIndex = new StatefulIndexPermssions(roles, actionGroups, actions, indices, universallyDeniedIndices, this.statefulIndexState);
            }
        } else {
            this.statefulIndexState.setState(ComponentState.State.SUSPENDED, "no_index_information");
        }
        this.componentState.updateStateFromParts();
        this.componentState.setConfigVersion(roles.getDocVersion());
        if (metricsLevel.detailedEnabled()) {
            this.indexActionChecks = new TimeAggregation.Nanoseconds();
            this.indexActionCheckResults = new CountAggregation();
            this.tenantActionChecks = new TimeAggregation.Nanoseconds();
            this.tenantActionCheckResults = new CountAggregation();
            this.indexActionTypes = new CountAggregation();
        } else if (metricsLevel.basicEnabled()) {
            this.indexActionChecks = new CountAggregation();
            this.indexActionCheckResults = new CountAggregation();
            this.tenantActionChecks = new CountAggregation();
            this.tenantActionCheckResults = new CountAggregation();
            this.indexActionTypes = new CountAggregation();
        } else {
            this.indexActionChecks = CountAggregation.noop();
            this.indexActionCheckResults = CountAggregation.noop();
            this.tenantActionChecks = CountAggregation.noop();
            this.tenantActionCheckResults = CountAggregation.noop();
            this.indexActionTypes = CountAggregation.noop();
        }
        this.indexActionCheckResults_ok = this.indexActionCheckResults.getSubCount("ok");
        this.indexActionCheckResults_partially = this.indexActionCheckResults.getSubCount("partially_ok");
        this.indexActionCheckResults_insufficient = this.indexActionCheckResults.getSubCount("insufficient");
        this.tenantActionCheckResults_ok = this.tenantActionCheckResults.getSubCount("ok");
        this.tenantActionCheckResults_insufficient = this.tenantActionCheckResults.getSubCount("insufficient");
        this.indexActionTypes_wellKnown = this.indexActionTypes.getSubCount("well_known");
        this.indexActionTypes_nonWellKnown = this.indexActionTypes.getSubCount("non_well_known");
        if (metricsLevel.basicEnabled()) {
            this.componentState.addMetrics("index_action_check_results", (Measurement)this.indexActionCheckResults);
            this.componentState.addMetrics("tenant_action_check_results", (Measurement)this.tenantActionCheckResults);
            this.componentState.addMetrics("index_action_checks", this.indexActionChecks, "tenant_action_checks", this.tenantActionChecks, "statful_index_rebuilds", (Measurement)this.statefulIndexRebuild);
            this.componentState.addMetrics("index_action_types", (Measurement)this.indexActionTypes);
        }
    }

    @Override
    public PrivilegesEvaluationResult hasClusterPermission(PrivilegesEvaluationContext context, Action action) throws PrivilegesEvaluationException {
        PrivilegesEvaluationResult result = this.clusterExclusions.contains(action, (Set<String>)context.getMappedRoles());
        if (result.getStatus() != PrivilegesEvaluationResult.Status.PENDING) {
            return result.missingPrivileges(action);
        }
        return this.cluster.contains(action, (Set<String>)context.getMappedRoles());
    }

    /*
     * Exception decompiling
     */
    @Override
    public PrivilegesEvaluationResult hasIndexPermission(PrivilegesEvaluationContext context, ImmutableSet<Action> actions, ActionRequestIntrospector.ResolvedIndices resolved) throws PrivilegesEvaluationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public PrivilegesEvaluationResult hasTenantPermission(PrivilegesEvaluationContext context, Action action, String requestedTenant) throws PrivilegesEvaluationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateIndices(Set<String> indices) {
        StatefulIndexPermssions statefulIndex = this.statefulIndex;
        if (statefulIndex != null && statefulIndex.indices.equals(indices)) {
            return;
        }
        try (Meter meter = Meter.basic((MetricsLevel)this.metricsLevel, (TimeAggregation)this.statefulIndexRebuild);){
            this.statefulIndex = new StatefulIndexPermssions(this.roles, this.actionGroups, this.actions, indices, this.universallyDeniedIndices, this.statefulIndexState);
            this.componentState.updateStateFromParts();
        }
    }

    private boolean isTenantValid(String requestedTenant) {
        if ("SGS_GLOBAL_TENANT".equals(requestedTenant) || USER_TENANT.equals(requestedTenant)) {
            return true;
        }
        return this.tenants.contains((Object)requestedTenant);
    }

    public ImmutableSet<String> getTenants() {
        return this.tenants;
    }

    public ActionGroup.FlattenedIndex getActionGroups() {
        return this.actionGroups;
    }

    private static boolean isActionName(String actionName) {
        return actionName.indexOf(58) != -1;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private /* synthetic */ boolean lambda$hasIndexPermission$2(String i) {
        return this.universallyDeniedIndices.matches(i);
    }

    private static /* synthetic */ boolean lambda$hasIndexPermission$1(Action a) {
        return a instanceof Action.WellKnownAction;
    }

    private /* synthetic */ void lambda$hasIndexPermission$0(Action action) {
        this.indexActionTypes.increment();
        if (action instanceof Action.WellKnownAction) {
            this.indexActionTypes_wellKnown.increment();
        } else {
            this.indexActionTypes_nonWellKnown.increment();
            if (this.metricsLevel.detailedEnabled()) {
                this.indexActionTypes_nonWellKnown.getSubCount(action.name()).increment();
            }
        }
    }

    static class IndexPattern {
        private final Pattern pattern;
        private final ImmutableList<Role.IndexPatterns.IndexPatternTemplate> patternTemplates;
        private final ImmutableList<Role.IndexPatterns.DateMathExpression> dateMathExpressions;

        IndexPattern(Pattern pattern, ImmutableList<Role.IndexPatterns.IndexPatternTemplate> patternTemplates, ImmutableList<Role.IndexPatterns.DateMathExpression> dateMathExpressions) {
            this.pattern = pattern;
            this.patternTemplates = patternTemplates;
            this.dateMathExpressions = dateMathExpressions;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean matches(String index, User user, PrivilegesEvaluationContext context, Meter meter) throws PrivilegesEvaluationException {
            if (this.pattern.matches(index)) {
                return true;
            }
            if (!this.patternTemplates.isEmpty()) {
                for (Role.IndexPatterns.IndexPatternTemplate patternTemplate : this.patternTemplates) {
                    try {
                        Meter subMeter = meter.basic("render_index_pattern_template");
                        try {
                            Pattern pattern = context.getRenderedPattern(patternTemplate.getTemplate());
                            if (!pattern.matches(index) || patternTemplate.getExclusions().matches(index)) continue;
                            boolean bl = true;
                            return bl;
                        }
                        finally {
                            if (subMeter == null) continue;
                            subMeter.close();
                        }
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new PrivilegesEvaluationException("Error while evaluating dynamic index pattern: " + patternTemplate, e);
                    }
                }
            }
            if (this.dateMathExpressions.isEmpty()) return false;
            try (Meter subMeter = meter.basic("render_date_math_expression");){
                block23: {
                    UnmodifiableIterator unmodifiableIterator = this.dateMathExpressions.iterator();
                    while (unmodifiableIterator.hasNext()) {
                        String resolvedExpression;
                        Role.IndexPatterns.DateMathExpression dateMathExpression = (Role.IndexPatterns.DateMathExpression)unmodifiableIterator.next();
                        try {
                            resolvedExpression = DateMathExpressionResolver.resolveExpression((String)dateMathExpression.getDateMathExpression());
                            if (!Template.containsPlaceholders((String)resolvedExpression)) {
                                Pattern pattern = Pattern.create((String)resolvedExpression);
                                if (!pattern.matches(index) || dateMathExpression.getExclusions().matches(index)) continue;
                                boolean bl = true;
                                return bl;
                            }
                        }
                        catch (Exception e) {
                            throw new PrivilegesEvaluationException("Error while evaluating date math expression: " + dateMathExpression, e);
                        }
                        Template patternTemplate = new Template(resolvedExpression, Pattern::create);
                        Pattern pattern = (Pattern)patternTemplate.render((AttributeSource)user);
                        if (!pattern.matches(index) || dateMathExpression.getExclusions().matches(index)) {
                            continue;
                        }
                        break block23;
                    }
                    return false;
                }
                boolean bl = true;
                return bl;
            }
        }

        public String toString() {
            if (this.pattern != null && this.patternTemplates != null && this.patternTemplates.size() != 0) {
                return this.pattern + " " + this.patternTemplates;
            }
            if (this.pattern != null) {
                return this.pattern.toString();
            }
            if (this.patternTemplates != null) {
                return this.patternTemplates.toString();
            }
            return "-/-";
        }

        static class Builder {
            private List<Pattern> constantPatterns = new ArrayList<Pattern>();
            private List<Role.IndexPatterns.IndexPatternTemplate> patternTemplates = new ArrayList<Role.IndexPatterns.IndexPatternTemplate>();
            private List<Role.IndexPatterns.DateMathExpression> dateMathExpressions = new ArrayList<Role.IndexPatterns.DateMathExpression>();

            Builder() {
            }

            void add(Role.IndexPatterns indexPattern) {
                this.constantPatterns.add(indexPattern.getPattern());
                this.patternTemplates.addAll((Collection<Role.IndexPatterns.IndexPatternTemplate>)indexPattern.getPatternTemplates());
                this.dateMathExpressions.addAll((Collection<Role.IndexPatterns.DateMathExpression>)indexPattern.getDateMathExpressions());
            }

            IndexPattern build() {
                return new IndexPattern(Pattern.join(this.constantPatterns), (ImmutableList<Role.IndexPatterns.IndexPatternTemplate>)ImmutableList.of(this.patternTemplates), (ImmutableList<Role.IndexPatterns.DateMathExpression>)ImmutableList.of(this.dateMathExpressions));
            }
        }
    }

    static class TenantPermissions
    implements ComponentStateProvider {
        private final ImmutableMap<Action, ImmutableMap<String, ImmutableSet<String>>> actionToTenantToRoles;
        private final ImmutableMap<String, ImmutableMap<Action, ImmutableSet<Template<Pattern>>>> roleToActionToTenantPattern;
        private final ImmutableList<PrivilegesEvaluationResult.Error> initializationErrors;
        private final ComponentState componentState;

        TenantPermissions(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, ImmutableSet<String> tenants) {
            ImmutableMap.Builder actionToTenantToRoles = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new ImmutableSet.Builder()));
            ImmutableMap.Builder roleToActionToTenantPattern = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new ImmutableSet.Builder()));
            ImmutableList.Builder initializationErrors = new ImmutableList.Builder();
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Tenant tenantPermissions : role.getTenantPermissions()) {
                        ImmutableSet<String> permissions = actionGroups.resolve((Collection<String>)tenantPermissions.getAllowedActions());
                        for (String permission : permissions) {
                            for (Template tenantPatternTemplate : tenantPermissions.getTenantPatterns()) {
                                if (tenantPatternTemplate.isConstant()) {
                                    Pattern tenantPattern = (Pattern)tenantPatternTemplate.getConstantValue();
                                    ImmutableSet matchingTenants = tenants.matching((Predicate)tenantPattern);
                                    if (Pattern.isConstant((String)permission)) {
                                        for (String tenant : matchingTenants) {
                                            ((ImmutableSet.Builder)((ImmutableMap.Builder)actionToTenantToRoles.get((Object)actions.get(permission))).get((Object)tenant)).add((Object)roleName);
                                        }
                                        continue;
                                    }
                                    Pattern actionPattern = Pattern.create((String)permission);
                                    ImmutableSet providedPrivileges = actions.tenantActions().matching(a -> actionPattern.matches(a.name()));
                                    for (Action.WellKnownAction action : providedPrivileges) {
                                        for (String tenant : matchingTenants) {
                                            ((ImmutableSet.Builder)((ImmutableMap.Builder)actionToTenantToRoles.get((Object)action)).get((Object)tenant)).add((Object)roleName);
                                        }
                                    }
                                    continue;
                                }
                                if (Pattern.isConstant((String)permission)) {
                                    ((ImmutableSet.Builder)((ImmutableMap.Builder)roleToActionToTenantPattern.get((Object)roleName)).get((Object)actions.get(permission))).add((Object)tenantPatternTemplate);
                                    continue;
                                }
                                Pattern actionPattern = Pattern.create((String)permission);
                                ImmutableSet providedPrivileges = actions.tenantActions().matching(a -> actionPattern.matches(a.name()));
                                for (Action.WellKnownAction action : providedPrivileges) {
                                    ((ImmutableSet.Builder)((ImmutableMap.Builder)roleToActionToTenantPattern.get((Object)roleName)).get((Object)action)).add((Object)tenantPatternTemplate);
                                }
                            }
                        }
                    }
                }
                catch (ConfigValidationException e) {
                    log.error("Invalid configuration in role: " + entry + "\nThis should have been caught before. Ignoring role.", (Throwable)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Invalid configuration in role", e, (String)entry.getKey()));
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Unexpected exception while processing role", e, (String)entry.getKey()));
                }
            }
            this.actionToTenantToRoles = actionToTenantToRoles.build(b -> b.build(ImmutableSet.Builder::build));
            this.roleToActionToTenantPattern = roleToActionToTenantPattern.build(b -> b.build(ImmutableSet.Builder::build));
            this.initializationErrors = initializationErrors.build();
            this.componentState = new ComponentState("tenant_permissions");
            this.componentState.setConfigVersion(roles.getDocVersion());
            if (this.initializationErrors.isEmpty()) {
                this.componentState.setInitialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                this.componentState.addDetail((Object)initializationErrors);
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }

        static /* synthetic */ ImmutableList access$400(TenantPermissions x0) {
            return x0.initializationErrors;
        }

        static /* synthetic */ ImmutableMap access$500(TenantPermissions x0) {
            return x0.actionToTenantToRoles;
        }

        static /* synthetic */ ImmutableMap access$600(TenantPermissions x0) {
            return x0.roleToActionToTenantPattern;
        }
    }

    static class StatefulIndexPermssions
    implements ComponentStateProvider {
        private final ImmutableMap<Action.WellKnownAction<?, ?, ?>, ImmutableMap<String, ImmutableSet<String>>> actionToIndexToRoles;
        private final ImmutableMap<Action.WellKnownAction<?, ?, ?>, ImmutableMap<String, ImmutableSet<String>>> excludedActionToIndexToRoles;
        private final ImmutableSet<String> rolesWithTemplatedExclusions;
        private final ImmutableSet<String> indices;
        private final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
        private final ComponentState componentState;
        private final Pattern universallyDeniedIndices;

        StatefulIndexPermssions(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, Set<String> indexNames, Pattern universallyDeniedIndices, ComponentState componentState) {
            ImmutableMap.Builder actionToIndexToRoles = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new ImmutableSet.Builder()));
            ImmutableMap.Builder excludedActionToIndexToRoles = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new ImmutableSet.Builder()));
            ImmutableSet.Builder rolesWithTemplatedExclusions = new ImmutableSet.Builder();
            ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    Action.WellKnownAction action;
                    UnmodifiableIterator unmodifiableIterator;
                    Object providedPrivileges;
                    Pattern pattern;
                    Action action2;
                    ImmutableSet<String> permissions;
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.ExcludeIndex excludedIndexPermissions : role.getExcludeIndexPermissions()) {
                        permissions = actionGroups.resolve((Collection<String>)excludedIndexPermissions.getActions());
                        if (excludedIndexPermissions.getIndexPatterns().getPattern().isWildcard()) continue;
                        if (!excludedIndexPermissions.getIndexPatterns().getPatternTemplates().isEmpty() || !excludedIndexPermissions.getIndexPatterns().getDateMathExpressions().isEmpty()) {
                            rolesWithTemplatedExclusions.add((Object)roleName);
                            continue;
                        }
                        for (String permission : permissions) {
                            Object index2;
                            Pattern indexPattern = excludedIndexPermissions.getIndexPatterns().getPattern();
                            if (Pattern.isConstant((String)permission)) {
                                action2 = actions.get(permission);
                                if (!(action2 instanceof Action.WellKnownAction)) continue;
                                for (Object index2 : indexPattern.iterateMatching(indexNames)) {
                                    ((ImmutableSet.Builder)((ImmutableMap.Builder)excludedActionToIndexToRoles.get((Object)((Action.WellKnownAction)action2))).get(index2)).add((Object)roleName);
                                }
                                continue;
                            }
                            pattern = Pattern.create((String)permission);
                            providedPrivileges = actions.indexActions().matching(a -> pattern.matches(a.name()));
                            index2 = indexPattern.iterateMatching(indexNames).iterator();
                            while (index2.hasNext()) {
                                String index3 = (String)index2.next();
                                unmodifiableIterator = providedPrivileges.iterator();
                                while (unmodifiableIterator.hasNext()) {
                                    action = (Action.WellKnownAction)unmodifiableIterator.next();
                                    ((ImmutableSet.Builder)((ImmutableMap.Builder)excludedActionToIndexToRoles.get((Object)action)).get((Object)index3)).add((Object)roleName);
                                }
                            }
                        }
                    }
                    for (Role.Index indexPermissions : role.getIndexPermissions()) {
                        permissions = actionGroups.resolve((Collection<String>)indexPermissions.getAllowedActions());
                        Pattern indexPattern = indexPermissions.getIndexPatterns().getPattern();
                        if (indexPattern.isWildcard() || indexPattern.isBlank()) continue;
                        for (String permission : permissions) {
                            if (Pattern.isConstant((String)permission)) {
                                action2 = actions.get(permission);
                                if (!(action2 instanceof Action.WellKnownAction)) continue;
                                for (Object index2 : indexPattern.iterateMatching(indexNames)) {
                                    ((ImmutableSet.Builder)((ImmutableMap.Builder)actionToIndexToRoles.get((Object)((Action.WellKnownAction)action2))).get(index2)).add((Object)roleName);
                                }
                                continue;
                            }
                            pattern = Pattern.create((String)permission);
                            providedPrivileges = actions.indexActions().matching(a -> pattern.matches(a.name()));
                            for (String index3 : indexPattern.iterateMatching(indexNames)) {
                                unmodifiableIterator = providedPrivileges.iterator();
                                while (unmodifiableIterator.hasNext()) {
                                    action = (Action.WellKnownAction)unmodifiableIterator.next();
                                    ((ImmutableSet.Builder)((ImmutableMap.Builder)actionToIndexToRoles.get((Object)action)).get((Object)index3)).add((Object)roleName);
                                }
                            }
                        }
                    }
                }
                catch (ConfigValidationException e) {
                    log.error("Invalid pattern in role: " + entry + "\nThis should have been caught before. Ignoring role.", (Throwable)e);
                    ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)((String)entry.getKey()))).with((Object)e);
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)((String)entry.getKey()))).with((Object)e);
                }
            }
            this.actionToIndexToRoles = actionToIndexToRoles.build(b -> b.build(ImmutableSet.Builder::build));
            this.excludedActionToIndexToRoles = excludedActionToIndexToRoles.build(b -> b.build(ImmutableSet.Builder::build));
            this.rolesWithTemplatedExclusions = rolesWithTemplatedExclusions.build();
            this.indices = ImmutableSet.of(indexNames);
            this.universallyDeniedIndices = universallyDeniedIndices;
            this.rolesToInitializationErrors = rolesToInitializationErrors.build(ImmutableList.Builder::build);
            this.componentState = componentState;
            this.componentState.setConfigVersion(roles.getDocVersion());
            if (this.rolesToInitializationErrors.isEmpty()) {
                this.componentState.setInitialized();
                this.componentState.setMessage("Initialized with " + this.indices.size() + " indices");
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                this.componentState.setMessage("Roles with initialization errors: " + this.rolesToInitializationErrors.keySet());
                this.componentState.addDetail((Object)rolesToInitializationErrors);
            }
        }

        PrivilegesEvaluationResult hasPermission(User user, ImmutableSet<String> mappedRoles, ImmutableSet<Action> actions, ActionRequestIntrospector.ResolvedIndices resolvedIndices, PrivilegesEvaluationContext context, CheckTable<String, Action> checkTable) throws PrivilegesEvaluationException {
            boolean allActionsWellKnown = actions.forAllApplies(a -> a instanceof Action.WellKnownAction);
            if (!allActionsWellKnown) {
                return null;
            }
            if (this.rolesWithTemplatedExclusions.containsAny(mappedRoles)) {
                return null;
            }
            block0: for (Action action : actions) {
                ImmutableMap indexToRoles = (ImmutableMap)this.actionToIndexToRoles.get((Object)action);
                if (indexToRoles == null) continue;
                for (String index : resolvedIndices.getLocalIndices()) {
                    ImmutableSet rolesWithPrivileges = (ImmutableSet)indexToRoles.get((Object)index);
                    if (rolesWithPrivileges == null || !rolesWithPrivileges.containsAny(mappedRoles) || this.isExcluded(action, index, user, mappedRoles, context) || !checkTable.check((Object)index, (Object)action)) continue;
                    break block0;
                }
            }
            if (checkTable.isComplete()) {
                return PrivilegesEvaluationResult.OK;
            }
            return null;
        }

        private boolean isExcluded(Action action, String index, User user, ImmutableSet<String> mappedRoles, PrivilegesEvaluationContext context) {
            if (this.universallyDeniedIndices.matches(index)) {
                return true;
            }
            ImmutableMap indexToRoles = (ImmutableMap)this.excludedActionToIndexToRoles.get((Object)action);
            if (indexToRoles == null) {
                return false;
            }
            ImmutableSet rolesWithPrivileges = (ImmutableSet)indexToRoles.get((Object)index);
            if (rolesWithPrivileges == null) {
                return false;
            }
            return rolesWithPrivileges.containsAny(mappedRoles);
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }

    static class IndexPermissionExclusions
    implements ComponentStateProvider {
        private final ImmutableMap<String, ImmutableMap<Action, IndexPattern>> rolesToActionToIndexPattern;
        private final ImmutableMap<String, ImmutableMap<Pattern, IndexPattern>> rolesToActionPatternToIndexPattern;
        private final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
        private final ComponentState componentState = new ComponentState("index_permission_exclusions");

        IndexPermissionExclusions(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions) {
            ImmutableMap.Builder rolesToActionToIndexPattern = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new IndexPattern.Builder()));
            ImmutableMap.Builder rolesToActionPatternsToIndexPattern = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new IndexPattern.Builder()));
            ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.ExcludeIndex indexPermissions : role.getExcludeIndexPermissions()) {
                        ImmutableSet<String> permissions = actionGroups.resolve((Collection<String>)indexPermissions.getActions());
                        for (String permission : permissions) {
                            if (Pattern.isConstant((String)permission)) {
                                ((IndexPattern.Builder)((ImmutableMap.Builder)rolesToActionToIndexPattern.get((Object)roleName)).get((Object)actions.get(permission))).add(indexPermissions.getIndexPatterns());
                                continue;
                            }
                            Pattern actionPattern = Pattern.create((String)permission);
                            ImmutableSet providedPrivileges = actions.indexActions().matching(a -> actionPattern.matches(a.name()));
                            for (Action.WellKnownAction action : providedPrivileges) {
                                ((IndexPattern.Builder)((ImmutableMap.Builder)rolesToActionToIndexPattern.get((Object)roleName)).get((Object)action)).add(indexPermissions.getIndexPatterns());
                            }
                            ((IndexPattern.Builder)((ImmutableMap.Builder)rolesToActionPatternsToIndexPattern.get((Object)roleName)).get((Object)actionPattern)).add(indexPermissions.getIndexPatterns());
                        }
                    }
                }
                catch (ConfigValidationException e) {
                    log.error("Invalid configuration in role: " + entry + "\nThis should have been caught before. Ignoring role.", (Throwable)e);
                    ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)((String)entry.getKey()))).with((Object)e);
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)((String)entry.getKey()))).with((Object)e);
                }
            }
            this.rolesToActionToIndexPattern = rolesToActionToIndexPattern.build(b -> b.build(IndexPattern.Builder::build));
            this.rolesToActionPatternToIndexPattern = rolesToActionPatternsToIndexPattern.build(b -> b.build(IndexPattern.Builder::build));
            this.rolesToInitializationErrors = rolesToInitializationErrors.build(ImmutableList.Builder::build);
            this.componentState.setConfigVersion(roles.getDocVersion());
            if (this.rolesToInitializationErrors.isEmpty()) {
                this.componentState.setInitialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                this.componentState.setMessage("Roles with initialization errors: " + this.rolesToInitializationErrors.keySet());
                this.componentState.addDetail((Object)rolesToInitializationErrors);
            }
        }

        boolean contains(ImmutableSet<String> mappedRoles, ImmutableSet<Action> actions) {
            boolean allActionsWellKnown = actions.forAllApplies(a -> a instanceof Action.WellKnownAction);
            for (String role : mappedRoles) {
                ImmutableMap actionPatternToIndexPattern;
                ImmutableMap actionToIndexPattern = (ImmutableMap)this.rolesToActionToIndexPattern.get((Object)role);
                if (actionToIndexPattern != null && actionToIndexPattern.containsAny(actions)) {
                    return true;
                }
                if (allActionsWellKnown || (actionPatternToIndexPattern = (ImmutableMap)this.rolesToActionPatternToIndexPattern.get((Object)role)) == null) continue;
                for (Pattern pattern : actionPatternToIndexPattern.keySet()) {
                    if (!actions.forAnyApplies(a -> pattern.test((Object)a.name()))) continue;
                    return true;
                }
            }
            return false;
        }

        void uncheckExclusions(CheckTable<String, Action> checkTable, User user, ImmutableSet<String> mappedRoles, ImmutableSet<Action> actions, ActionRequestIntrospector.ResolvedIndices resolved, PrivilegesEvaluationContext context, Meter meter) throws PrivilegesEvaluationException {
            block21: {
                block20: {
                    try (Meter subMeter = meter.basic("well_known_actions_uncheck_exclusions");){
                        for (String role : mappedRoles) {
                            ImmutableMap actionToIndexPattern = (ImmutableMap)this.rolesToActionToIndexPattern.get((Object)role);
                            if (actionToIndexPattern == null) continue;
                            for (Action action : actions) {
                                IndexPattern indexPattern = (IndexPattern)actionToIndexPattern.get((Object)action);
                                if (indexPattern == null) continue;
                                for (String index : checkTable.iterateCheckedRows((Object)action)) {
                                    if (!indexPattern.matches(index, user, context, subMeter)) continue;
                                    checkTable.uncheck((Object)index, (Object)action);
                                }
                                if (!checkTable.isBlank()) continue;
                                break block20;
                            }
                        }
                    }
                }
                boolean allActionsWellKnown = actions.forAllApplies(a -> a instanceof Action.WellKnownAction);
                if (!checkTable.isBlank() && !allActionsWellKnown) {
                    try (Meter subMeter = meter.basic("non_well_known_actions_uncheck_exclusions");){
                        for (String role : mappedRoles) {
                            ImmutableMap actionPatternToIndexPattern = (ImmutableMap)this.rolesToActionPatternToIndexPattern.get((Object)role);
                            if (actionPatternToIndexPattern == null) continue;
                            for (Action action : actions) {
                                if (action instanceof Action.WellKnownAction) continue;
                                for (Map.Entry entry : actionPatternToIndexPattern.entrySet()) {
                                    Pattern actionPattern = (Pattern)entry.getKey();
                                    IndexPattern indexPattern = (IndexPattern)entry.getValue();
                                    if (!actionPattern.matches(action.name())) continue;
                                    for (String index : checkTable.iterateCheckedRows((Object)action)) {
                                        if (!indexPattern.matches(index, user, context, subMeter)) continue;
                                        checkTable.uncheck((Object)index, (Object)action);
                                    }
                                    if (!checkTable.isBlank()) continue;
                                    break block21;
                                }
                            }
                        }
                    }
                }
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }

    static class IndexPermissions
    implements ComponentStateProvider {
        private final ImmutableMap<String, ImmutableMap<Action, IndexPattern>> rolesToActionToIndexPattern;
        private final ImmutableMap<String, ImmutableMap<Pattern, IndexPattern>> rolesToActionPatternToIndexPattern;
        private final ImmutableMap<Action, ImmutableSet<String>> actionToRolesWithWildcardIndexPrivileges;
        private final ImmutableList<PrivilegesEvaluationResult.Error> initializationErrors;
        private final ComponentState componentState = new ComponentState("index_permissions");

        IndexPermissions(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions) {
            ImmutableMap.Builder rolesToActionToIndexPattern = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new IndexPattern.Builder()));
            ImmutableMap.Builder rolesToActionPatternsToIndexPattern = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new IndexPattern.Builder()));
            ImmutableMap.Builder actionToRolesWithWildcardIndexPrivileges = new ImmutableMap.Builder().defaultValue(k -> new ImmutableSet.Builder());
            ImmutableList.Builder initializationErrors = new ImmutableList.Builder();
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Index indexPermissions : role.getIndexPermissions()) {
                        ImmutableSet<String> permissions = actionGroups.resolve((Collection<String>)indexPermissions.getAllowedActions());
                        for (String permission : permissions) {
                            if (Pattern.isConstant((String)permission)) {
                                ((IndexPattern.Builder)((ImmutableMap.Builder)rolesToActionToIndexPattern.get((Object)roleName)).get((Object)actions.get(permission))).add(indexPermissions.getIndexPatterns());
                                if (!indexPermissions.getIndexPatterns().getPattern().isWildcard()) continue;
                                ((ImmutableSet.Builder)actionToRolesWithWildcardIndexPrivileges.get((Object)actions.get(permission))).add((Object)roleName);
                                continue;
                            }
                            Pattern actionPattern = Pattern.create((String)permission);
                            ImmutableSet providedPrivileges = actions.indexActions().matching(a -> actionPattern.matches(a.name()));
                            for (Action.WellKnownAction action : providedPrivileges) {
                                ((IndexPattern.Builder)((ImmutableMap.Builder)rolesToActionToIndexPattern.get((Object)roleName)).get((Object)action)).add(indexPermissions.getIndexPatterns());
                                if (!indexPermissions.getIndexPatterns().getPattern().isWildcard()) continue;
                                ((ImmutableSet.Builder)actionToRolesWithWildcardIndexPrivileges.get((Object)action)).add((Object)roleName);
                            }
                            ((IndexPattern.Builder)((ImmutableMap.Builder)rolesToActionPatternsToIndexPattern.get((Object)roleName)).get((Object)actionPattern)).add(indexPermissions.getIndexPatterns());
                        }
                    }
                }
                catch (ConfigValidationException e) {
                    log.error("Invalid configuration in role: " + entry + "\nThis should have been caught before. Ignoring role.", (Throwable)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Invalid pattern in role", e, (String)entry.getKey()));
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Unexpected exception while processing role", e, (String)entry.getKey()));
                }
            }
            this.rolesToActionToIndexPattern = rolesToActionToIndexPattern.build(b -> b.build(IndexPattern.Builder::build));
            this.rolesToActionPatternToIndexPattern = rolesToActionPatternsToIndexPattern.build(b -> b.build(IndexPattern.Builder::build));
            this.actionToRolesWithWildcardIndexPrivileges = actionToRolesWithWildcardIndexPrivileges.build(ImmutableSet.Builder::build);
            this.initializationErrors = initializationErrors.build();
            this.componentState.setConfigVersion(roles.getDocVersion());
            if (this.initializationErrors.isEmpty()) {
                this.componentState.setInitialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                this.componentState.addDetail((Object)initializationErrors);
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }

        static /* synthetic */ ImmutableList access$000(IndexPermissions x0) {
            return x0.initializationErrors;
        }

        static /* synthetic */ ImmutableMap access$100(IndexPermissions x0) {
            return x0.actionToRolesWithWildcardIndexPrivileges;
        }

        static /* synthetic */ ImmutableMap access$200(IndexPermissions x0) {
            return x0.rolesToActionToIndexPattern;
        }

        static /* synthetic */ ImmutableMap access$300(IndexPermissions x0) {
            return x0.rolesToActionPatternToIndexPattern;
        }
    }

    static class ClusterPermissionExclusions
    implements ComponentStateProvider {
        private final ImmutableMap<Action, ImmutableSet<String>> actionToRoles;
        private final ImmutableMap<String, Pattern> rolesToActionPattern;
        private final ImmutableList<PrivilegesEvaluationResult.Error> initializationErrors;
        private final ComponentState componentState = new ComponentState("cluster_permission_exclusions");

        ClusterPermissionExclusions(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions) {
            ImmutableMap.Builder actionToRoles = new ImmutableMap.Builder().defaultValue(k -> new ImmutableSet.Builder());
            ImmutableMap.Builder rolesToActionPattern = new ImmutableMap.Builder();
            ImmutableList.Builder initializationErrors = new ImmutableList.Builder();
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    ImmutableSet<String> permissions = actionGroups.resolve((Collection<String>)role.getExcludeClusterPermissions());
                    ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                    for (String permission : permissions) {
                        if (Pattern.isConstant((String)permission)) {
                            ((ImmutableSet.Builder)actionToRoles.get((Object)actions.get(permission))).add((Object)roleName);
                            continue;
                        }
                        Pattern pattern = Pattern.create((String)permission);
                        ImmutableSet providedPrivileges = actions.clusterActions().matching(a -> pattern.matches(a.name()));
                        for (Action.WellKnownAction action : providedPrivileges) {
                            ((ImmutableSet.Builder)actionToRoles.get((Object)action)).add((Object)roleName);
                        }
                        patterns.add(pattern);
                    }
                    if (patterns.isEmpty()) continue;
                    rolesToActionPattern.put((Object)roleName, (Object)Pattern.join(patterns));
                }
                catch (ConfigValidationException e) {
                    log.error("Invalid pattern in role: " + entry + "\nThis should have been caught before. Ignoring role.", (Throwable)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Invalid pattern in role", e, (String)entry.getKey()));
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Unexpected exception while processing role", e, (String)entry.getKey()));
                }
            }
            this.actionToRoles = actionToRoles.build(ImmutableSet.Builder::build);
            this.rolesToActionPattern = rolesToActionPattern.build();
            this.initializationErrors = initializationErrors.build();
            this.componentState.setConfigVersion(roles.getDocVersion());
            if (this.initializationErrors.isEmpty()) {
                this.componentState.setInitialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                this.componentState.addDetail(this.initializationErrors);
            }
        }

        PrivilegesEvaluationResult contains(Action action, Set<String> roles) {
            ImmutableSet rolesWithPrivileges = (ImmutableSet)this.actionToRoles.get((Object)action);
            if (rolesWithPrivileges != null && rolesWithPrivileges.containsAny(roles)) {
                return PrivilegesEvaluationResult.INSUFFICIENT.reason("Privilege exclusion in role " + rolesWithPrivileges.intersection(roles));
            }
            if (!(action instanceof Action.WellKnownAction)) {
                for (String role : roles) {
                    Pattern pattern = (Pattern)this.rolesToActionPattern.get((Object)role);
                    if (pattern == null || !pattern.matches(action.name())) continue;
                    return PrivilegesEvaluationResult.INSUFFICIENT.reason("Privilege exclusion in role " + role);
                }
            }
            return PrivilegesEvaluationResult.PENDING;
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }

    static class ClusterPermissions
    implements ComponentStateProvider {
        private final ImmutableMap<Action, ImmutableSet<String>> actionToRoles;
        private final ImmutableSet<String> rolesWithWildcardPermissions;
        private final ImmutableMap<String, Pattern> rolesToActionPattern;
        private final ImmutableList<PrivilegesEvaluationResult.Error> initializationErrors;
        private final ComponentState componentState = new ComponentState("cluster_permissions");
        private final CountAggregation checks;
        private final CountAggregation nonWellKnownChecks;
        private final CountAggregation wildcardChecks;
        private final MetricsLevel metricsLevel;

        ClusterPermissions(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, MetricsLevel metricsLevel) {
            ImmutableMap.Builder actionToRoles = new ImmutableMap.Builder().defaultValue(k -> new ImmutableSet.Builder());
            ImmutableSet.Builder rolesWithWildcardPermissions = new ImmutableSet.Builder();
            ImmutableMap.Builder rolesToActionPattern = new ImmutableMap.Builder();
            ImmutableList.Builder initializationErrors = new ImmutableList.Builder();
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    ImmutableSet<String> permissions = actionGroups.resolve((Collection<String>)role.getClusterPermissions());
                    ImmutableSet<String> excludedPermissions = actionGroups.resolve((Collection<String>)role.getExcludeClusterPermissions());
                    Pattern excludedPattern = Pattern.createWithoutExclusions(excludedPermissions);
                    ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                    if (permissions.contains((Object)"*") && excludedPermissions.isEmpty()) {
                        rolesWithWildcardPermissions.add((Object)roleName);
                        continue;
                    }
                    for (String permission : permissions) {
                        if (Pattern.isConstant((String)permission)) {
                            if (excludedPattern.matches(permission) || !RoleBasedActionAuthorization.isActionName(permission)) continue;
                            ((ImmutableSet.Builder)actionToRoles.get((Object)actions.get(permission))).add((Object)roleName);
                            continue;
                        }
                        Pattern pattern = Pattern.create((String)permission);
                        ImmutableSet providedPrivileges = actions.clusterActions().matching(a -> pattern.matches(a.name()) && !excludedPattern.matches(a.name()));
                        for (Action.WellKnownAction action : providedPrivileges) {
                            ((ImmutableSet.Builder)actionToRoles.get((Object)action)).add((Object)roleName);
                        }
                        patterns.add(pattern);
                    }
                    if (patterns.isEmpty()) continue;
                    rolesToActionPattern.put((Object)roleName, (Object)Pattern.join(patterns).excluding(excludedPattern));
                }
                catch (ConfigValidationException e) {
                    log.error("Invalid pattern in role: " + entry + "\nThis should have been caught before. Ignoring role.", (Throwable)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Invalid pattern in role", e, (String)entry.getKey()));
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Unexpected exception while processing role", e, (String)entry.getKey()));
                }
            }
            this.actionToRoles = actionToRoles.build(ImmutableSet.Builder::build);
            this.rolesWithWildcardPermissions = rolesWithWildcardPermissions.build();
            this.rolesToActionPattern = rolesToActionPattern.build();
            this.initializationErrors = initializationErrors.build();
            this.componentState.setConfigVersion(roles.getDocVersion());
            this.checks = CountAggregation.basic((MetricsLevel)metricsLevel);
            this.nonWellKnownChecks = this.checks.getSubCount("non_well_known_actions");
            this.wildcardChecks = this.checks.getSubCount("wildcard");
            this.metricsLevel = metricsLevel;
            if (metricsLevel.basicEnabled()) {
                this.componentState.addMetrics("checks", (Measurement)this.checks);
                this.componentState.addMetrics("action_to_roles_map", (Measurement)new Count((long)actionToRoles.size()));
                this.componentState.addMetrics("roles_to_action_pattern_map", (Measurement)new Count((long)rolesToActionPattern.size()));
            }
            if (this.initializationErrors.isEmpty()) {
                this.componentState.setInitialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                this.componentState.addDetail((Object)initializationErrors);
            }
        }

        PrivilegesEvaluationResult contains(Action action, Set<String> roles) {
            this.checks.increment();
            if (this.rolesWithWildcardPermissions.containsAny(roles)) {
                this.wildcardChecks.increment();
                return PrivilegesEvaluationResult.OK;
            }
            ImmutableSet rolesWithPrivileges = (ImmutableSet)this.actionToRoles.get((Object)action);
            if (rolesWithPrivileges != null && rolesWithPrivileges.containsAny(roles)) {
                return PrivilegesEvaluationResult.OK;
            }
            if (!(action instanceof Action.WellKnownAction)) {
                try (Meter m = Meter.basic((MetricsLevel)MetricsLevel.BASIC, (Measurement)this.nonWellKnownChecks);){
                    if (this.metricsLevel.detailedEnabled()) {
                        m.count(action.name());
                    }
                    for (String role : roles) {
                        Pattern pattern = (Pattern)this.rolesToActionPattern.get((Object)role);
                        if (pattern == null || !pattern.matches(action.name())) continue;
                        PrivilegesEvaluationResult privilegesEvaluationResult = PrivilegesEvaluationResult.OK;
                        return privilegesEvaluationResult;
                    }
                }
            }
            return PrivilegesEvaluationResult.INSUFFICIENT.with(this.initializationErrors).missingPrivileges(action);
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }
}

